Ext.data.JsonP.sol_dev_ix_ActionUtils({"tagname":"class","name":"sol.dev.ix.ActionUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.dev.ix.ActionUtils.js","href":"lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils"}],"author":[{"tagname":"author","name":"JHR, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloix":true,"requires":["sol.common.Config","sol.common.Map","sol.common.RepoUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"createWorkflowName","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-createWorkflowName","meta":{"private":true}},{"name":"createWorkflowTemplate","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-createWorkflowTemplate","meta":{"private":true}},{"name":"existPathFullNameSpace","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-existPathFullNameSpace","meta":{"private":true}},{"name":"existWorkflowTemplate","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-existWorkflowTemplate","meta":{"private":true}},{"name":"generateDocumentContent","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-generateDocumentContent","meta":{"private":true}},{"name":"generateEntry","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-generateEntry","meta":{"private":true}},{"name":"generateReferences","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-generateReferences","meta":{"private":true}},{"name":"generateSordNameDesc","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-generateSordNameDesc","meta":{"private":true}},{"name":"generateWfTemplate","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-generateWfTemplate","meta":{"private":true}},{"name":"getOldDocuments","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-getOldDocuments","meta":{"private":true}},{"name":"getRelPath","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-getRelPath","meta":{"private":true}},{"name":"getSolutionSord","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-getSolutionSord","meta":{"private":true}},{"name":"getSubFolderId","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-getSubFolderId","meta":{"private":true}},{"name":"getcomponentSord","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-getcomponentSord","meta":{"private":true}},{"name":"importWorkflow","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-importWorkflow","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isJsonConfig","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-isJsonConfig","meta":{}},{"name":"isOfficeDocument","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-isOfficeDocument","meta":{"private":true}},{"name":"loadConfigDev","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-loadConfigDev","meta":{}},{"name":"loadConfigDevInternal","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-loadConfigDevInternal","meta":{}},{"name":"loadTemplateConfig","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-loadTemplateConfig","meta":{"private":true}},{"name":"mergeRecursive","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-mergeRecursive","meta":{}},{"name":"moveSord","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-moveSord","meta":{"private":true}},{"name":"processComponent","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-processComponent","meta":{"private":true}},{"name":"processOldDocuments","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-processOldDocuments","meta":{"private":true}},{"name":"setLogger","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-setLogger","meta":{}},{"name":"setObjId","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-setObjId","meta":{}},{"name":"startCreateActionWorkflow","tagname":"method","owner":"sol.dev.ix.ActionUtils","id":"method-startCreateActionWorkflow","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.dev.ix.ActionUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.dev.ix.ActionUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.Map' rel='sol.common.Map' class='docClass'>sol.common.Map</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils' target='_blank'>lib_sol.dev.ix.ActionUtils.js</a></div></pre><div class='doc-contents'><p>Utility functions for action handling.</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-createWorkflowName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-createWorkflowName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-createWorkflowName' class='name expandable'>createWorkflowName</a>( <span class='pre'>wfName</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createWorkflowTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-createWorkflowTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-createWorkflowTemplate' class='name expandable'>createWorkflowTemplate</a>( <span class='pre'>wfName</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfName</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-existPathFullNameSpace' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-existPathFullNameSpace' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-existPathFullNameSpace' class='name expandable'>existPathFullNameSpace</a>( <span class='pre'>templateId</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>templateId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-existWorkflowTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-existWorkflowTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-existWorkflowTemplate' class='name expandable'>existWorkflowTemplate</a>( <span class='pre'>wfName</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-generateDocumentContent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-generateDocumentContent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-generateDocumentContent' class='name expandable'>generateDocumentContent</a>( <span class='pre'>tempSord, sordf, type, oldDocuments</span> ) : Object[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tempSord</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>sordf</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>type</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>oldDocuments</span> : Object[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-generateEntry' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-generateEntry' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-generateEntry' class='name expandable'>generateEntry</a>( <span class='pre'>objId, tempSord, folder, mode, type, references</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>tempSord</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>folder</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>mode</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>type</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>references</span> : Object[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-generateReferences' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-generateReferences' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-generateReferences' class='name expandable'>generateReferences</a>( <span class='pre'>objSord, references</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objSord</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>references</span> : Object[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-generateSordNameDesc' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-generateSordNameDesc' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-generateSordNameDesc' class='name expandable'>generateSordNameDesc</a>( <span class='pre'>tempSord, sordf</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tempSord</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>sordf</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-generateWfTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-generateWfTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-generateWfTemplate' class='name expandable'>generateWfTemplate</a>( <span class='pre'>tempSord, wftemplate, type</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tempSord</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>wftemplate</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>type</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getOldDocuments' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-getOldDocuments' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-getOldDocuments' class='name expandable'>getOldDocuments</a>( <span class='pre'>objId, folder, type</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>folder</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>type</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getRelPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-getRelPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-getRelPath' class='name expandable'>getRelPath</a>( <span class='pre'>parentId, folderId</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>parentId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>folderId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSolutionSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-getSolutionSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-getSolutionSord' class='name expandable'>getSolutionSord</a>( <span class='pre'>objSord</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objSord</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSubFolderId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-getSubFolderId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-getSubFolderId' class='name expandable'>getSubFolderId</a>( <span class='pre'>parentId, folder</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>parentId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>folder</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getcomponentSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-getcomponentSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-getcomponentSord' class='name expandable'>getcomponentSord</a>( <span class='pre'>objId</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-importWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-importWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-importWorkflow' class='name expandable'>importWorkflow</a>( <span class='pre'>sordf, wfName</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sordf</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>wfName</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-isJsonConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-isJsonConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-isJsonConfig' class='name expandable'>isJsonConfig</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if an de.elo.ix.client.Sord is from type JSON-Configuration ...</div><div class='long'><p>Checks, if an de.elo.ix.client.Sord is from type JSON-Configuration</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isOfficeDocument' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-isOfficeDocument' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-isOfficeDocument' class='name expandable'>isOfficeDocument</a>( <span class='pre'>ext</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ext</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-loadConfigDev' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-loadConfigDev' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-loadConfigDev' class='name expandable'>loadConfigDev</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads the configuration from the JSON dev: /Administration/Business Solutions/development_internal/Configuration/dev....</div><div class='long'><p>Loads the configuration from the JSON dev: <code>/Administration/Business Solutions/development_internal/Configuration/dev.config</code></p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-loadConfigDevInternal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-loadConfigDevInternal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-loadConfigDevInternal' class='name expandable'>loadConfigDevInternal</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads the configuration from the JSON dev: /Administration/Business Solutions/development_internal/Configuration/dev....</div><div class='long'><p>Loads the configuration from the JSON dev: <code>/Administration/Business Solutions/development_internal/Configuration/dev.config</code></p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-loadTemplateConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-loadTemplateConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-loadTemplateConfig' class='name expandable'>loadTemplateConfig</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-mergeRecursive' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-mergeRecursive' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-mergeRecursive' class='name expandable'>mergeRecursive</a>( <span class='pre'>obj1, obj2</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Recursively merge properties of two objects ...</div><div class='long'><p>Recursively merge properties of two objects</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj1</span> : Object<div class='sub-desc'><p>JSON-Configuration</p>\n</div></li><li><span class='pre'>obj2</span> : Object<div class='sub-desc'><p>JSON-Configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Merged JSON-Configuration</p>\n</div></li></ul></div></div></div><div id='method-moveSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-moveSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-moveSord' class='name expandable'>moveSord</a>( <span class='pre'>objId, targetId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>targetId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-processComponent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-processComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-processComponent' class='name expandable'>processComponent</a>( <span class='pre'>objSord</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objSord</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-processOldDocuments' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-processOldDocuments' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-processOldDocuments' class='name expandable'>processOldDocuments</a>( <span class='pre'>oldDocuments, folderId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oldDocuments</span> : Object[]<div class='sub-desc'>\n</div></li><li><span class='pre'>folderId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setLogger' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-setLogger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-setLogger' class='name expandable'>setLogger</a>( <span class='pre'>classLogger</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the logger object from using class ...</div><div class='long'><p>Sets the logger object from using class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classLogger</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-setObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-setObjId' class='name expandable'>setObjId</a>( <span class='pre'>classObjId</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the logger object from using class ...</div><div class='long'><p>Sets the logger object from using class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classObjId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-startCreateActionWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.dev.ix.ActionUtils'>sol.dev.ix.ActionUtils</span><br/><a href='source/lib_sol.dev.ix.ActionUtils.html#sol-dev-ix-ActionUtils-method-startCreateActionWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.dev.ix.ActionUtils-method-startCreateActionWorkflow' class='name expandable'>startCreateActionWorkflow</a>( <span class='pre'>objId, wfName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Starts the workflow defined in the configuration: dev.requestWorkflows.createAction.workflowTemplateName ...</div><div class='long'><p>Starts the workflow defined in the configuration: <code>dev.requestWorkflows.createAction.workflowTemplateName</code></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>The objId on which the workflow should be started</p>\n</div></li><li><span class='pre'>wfName</span> : String<div class='sub-desc'><p>The Name of the new workflow</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The flowId of the new workflow</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true,"singleton":true}});